﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Tools" %>

<%@ Import Namespace="System.Text" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Types" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Nota korygująca</title>
	<script runat="server">
        		public class Params : ContextBase
		{
			public Params(Context ctx)
				: base(ctx)
			{
			}


            [Priority(99)]
            [Caption("Adres korespondencyjny")]
            public Boolean AdresKorespondencyjny { get; set; }
		}


		private Params prm;

		[Context]
		public Params Prm
		{ set { prm = value; } }
		
        private String nabywca;

		void OnContextLoad(Object sender, EventArgs args)
		{
			var doc = (NotaKorygujaca)dc[typeof(NotaKorygujaca)];
			DRNota.DataSource = new [] { doc, doc };

   			var pieczatka = ReportHeader.GetPieczątka(dc);
            nabywca = Concatenate(pieczatka.NazwaFormatowana, new [] { pieczatka.Adres.Linia1, pieczatka.Adres.Linia2 }, BuildNIP(pieczatka.NIP));

			IdPieczatka1.EditValue = pieczatka.NazwaFormatowana;
			IdPieczatka2.EditValue = pieczatka.Adres.Linia1;
			IdPieczatka3.EditValue = pieczatka.Adres.Linia2;
			IdPieczatka4.EditValue = pieczatka.NIP;

            var kh = doc.Podmiot as Kontrahent;
            if (kh != null && prm.AdresKorespondencyjny && !String.IsNullOrWhiteSpace(kh.KorespondencjaNazwaFirmy + kh.AdresDoKorespondencji.Linia1 + kh.AdresDoKorespondencji.Linia2))
            {
                LblAdPodmiot.EditValue = String.IsNullOrWhiteSpace(kh.KorespondencjaNazwaFirmy) ? doc.Podmiot.NazwaFormatowana : kh.KorespondencjaNazwaFirmy;
                LblAdAdresLinia1.EditValue = kh.AdresDoKorespondencji.Linia1;
                LblAdAdresLinia2.EditValue = kh.AdresDoKorespondencji.Linia2;
                ScAdresat.Visible = true;
            }
            LblPodmiot.EditValue = doc.Podmiot.NazwaFormatowana;
            LblAdresLinia1.EditValue = doc.Podmiot.Adres.Linia1;
            LblAdresLinia2.EditValue = doc.Podmiot.Adres.Linia2;
            EuVAT.EditValue = doc.Podmiot.EuVAT == "" ? "" : "NIP: " + doc.Podmiot.EuVAT;
		}


        private void DRNota_BeforeRow(object sender, EventArgs e)
		{
            var nota = (NotaKorygujaca)DRNota.CurrentRow;
            ReportHeaderId.Title = String.Format("Nota korygująca|</strong>Numer: <strong>{0}</strong>|Data: <strong>{1}", nota.Numer, nota.Data);
        }

        private void Ewidencja_BeforeRow(object sender, RowEventArgs e)
		{
            var dok = (DokEwidencji)e.Row;
	        var dokPodm = dok as PodmiotEwidencja;
	        if (dokPodm != null)
	        {
		        var dk = dokPodm.DaneKontrahenta;
		        ColSprzedawca.EditValue = Concatenate(dk.Nazwa, new [] { dk.Adres.Linia1, dk.Adres.Linia2 }, BuildNIP(dk.EuVAT));
	        }
	        else
		        ColSprzedawca.EditValue = Concatenate(dok.Podmiot.Nazwa, new [] { dok.Podmiot.Adres.Linia1, dok.Podmiot.Adres.Linia2 }, BuildNIP(dok.Podmiot.EuVAT));
            ColNabywca.EditValue = nabywca;
		}
			

        private static String BuildNIP(String nip)
		{
            return String.IsNullOrEmpty(nip) ? String.Empty : "NIP: " + nip;
		}


        private static String Concatenate(params Object[] objects)
		{
            var sBuilder = new StringBuilder();

            foreach (Object obj in objects)
			{
                var strArr = obj as String[];
                if (strArr != null)
                {
                    if (sBuilder.Length > 0) sBuilder.Append(";");
                    foreach(String str in strArr)
                        if (!String.IsNullOrEmpty(str))
                            sBuilder.AppendFormat(" {0}", str);
		    	}
                else
	    		{
                    var value = obj.ToString();
                    if (!String.IsNullOrEmpty(value))
                    {
                        if (sBuilder.Length > 0) sBuilder.Append("; ");
                        sBuilder.Append(value);
                      }
			    }
		    }
		
            return HttpUtility.HtmlEncode(sBuilder.ToString());
        }
		
	</script>
</head>
<body>

	<form id="NotaKorygujaca" method="post" runat="server">
	<ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad" TypeName="Soneta.Kasa.NotaKorygujaca,Soneta.Kasa" />

	<ea:DataRepeater ID="DRNota" runat="server" Width="100%" OnBeforeRow="DRNota_BeforeRow">
	<ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="false" />
	
	<cc1:ReportHeader ID="ReportHeaderId" Title="" runat="server" />
	<table width="100%" style="margin-top:15px">
		<tr>
			<td valign="top" width="50%">
				<em style="text-decoration: underline;">Wystawca noty:</em>
				<div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative; margin-top: 3pt;">
					<ea:DataLabel ID="IdPieczatka1" runat="server" EncodeHTML="True" /><br />
					<ea:DataLabel ID="IdPieczatka2" runat="server" Bold="False" EncodeHTML="True" /><br />
					<ea:DataLabel ID="IdPieczatka3" runat="server" Bold="False" EncodeHTML="True" /><br />
					<ea:DataLabel ID="Datalabel5" runat="server" DataMember="" /><br />
					NIP: <ea:DataLabel ID="IdPieczatka4" runat="server" Bold="False" EncodeHTML="True" />
				</div>
			</td>
			<td valign="top" width="50%">
				<em style="text-decoration: underline;">Odbiorca noty:</em>
				<div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative; margin-top: 3pt;">
					<ea:DataLabel ID="LblPodmiot" runat="server" EncodeHTML="True" /><br />
					<ea:DataLabel ID="LblAdresLinia1" runat="server" Bold="False" EncodeHTML="True" /><br />
					<ea:DataLabel ID="LblAdresLinia2" runat="server" Bold="False" EncodeHTML="True" /><br />
					<ea:DataLabel ID="Datalabel17" runat="server" DataMember="" /><br />
					<ea:DataLabel ID="EuVAT" runat="server" Bold="False" EncodeHTML="True" />
				</div>
			</td>
        </tr>
        <tr>
            <td valign="top" width="50%">&nbsp;</td>
            <td valign="top" width="50%">
                <ea:Section runat="server" ID="ScAdresat" Visible="false">
                <em style="text-decoration: underline;">Adres korespondencyjny:</em>
				<div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative; margin-top: 3pt;">
			        <ea:DataLabel ID="LblAdPodmiot" runat="server" /><br />
			        <ea:DataLabel ID="LblAdAdresLinia1" runat="server" /><br />
			        <ea:DataLabel ID="LblAdAdresLinia2" runat="server" /><br />
					<ea:DataLabel ID="Datalabel3" runat="server" DataMember="" /><br />
		        </div>
                </ea:Section>
            </td>
		</tr>
	</table>

         <div style="width: 100%; margin-top: 5mm; margin-bottom: 3mm;">
		<em style="text-decoration: underline;">Korygowane dokumenty:</em>
	</div>
            <ea:Grid runat="server" ID="Grid1" DataMember="DokumentyKorygowaneView" RowsInRow="2" OnBeforeRow="Ewidencja_BeforeRow">
                <columns>
			<ea:GridColumn runat="server" Caption="Numer faktury" RowSpan="2" Width="20" DataMember="NumerDokumentu" />
			<ea:GridColumn runat="server" Caption="Data wystawienia" DataMember="DataDokumentu" Align="Center" Width="17" />
			<ea:GridColumn runat="server" Caption="Data dostawy *" DataMember="DataOperacji" Align="Center" Width="17" />
			<ea:GridColumn runat="server" Caption="Sprzedawca" ID="ColSprzedawca" Width="0" />
			<ea:GridColumn runat="server" Caption="Nabywca" ID="ColNabywca" Width="0" />
		</columns>
	</ea:Grid>

	<div style="width: 100%; border: 1px solid #CCC; margin-top: 10mm; padding: 0.2cm">
		<em style="text-decoration: underline;">Treść korygowana:</em>
		<div style="font-family: Tahoma; font-size: 9pt; margin-bottom: 0.3cm">
			<ea:DataLabel ID="Datalabel1" runat="server" DataMember="TrescKorygowana" Bold="False" EncodeHTML="True" />
		</div>
		<em style="text-decoration: underline;">Treść prawidłowa:</em>
		<div style="font-family: Tahoma; font-size: 9pt;">
			<ea:DataLabel ID="Datalabel2" runat="server" DataMember="TrescPrawidlowa" Bold="False" EncodeHTML="True" />
		</div>
            </div>

            <p />
            <div>
                *) Data dokonania lub zakończenia dostawy towarów, data wykonania usługi lub data otrzymania zaliczki.
	</div>
            <p />

	<cc1:ReportFooter ID="ReportfooterId" runat="server" TheEnd="False" Height="105px">
                <subtitles>
			<cc1:FooterSubtitle ID="FooterSubtitle1" runat="server" Width="50" Caption="Podpis osoby upoważnionej do wystawienia noty korygującej" />
			<cc1:FooterSubtitle ID="FooterSubtitle2" runat="server" Width="50" Caption="Podpis osoby upoważnionej do odbioru noty korygującej" />
		</subtitles>
	</cc1:ReportFooter>
	</ea:DataRepeater>
	</form>
</body>
</html>
